import {ITrainsCoach} from 'reducers/trains/order/types';

import {TrainsOrderStateInterface} from 'reducers/trains/order/reducer';

import getCoachesByCategory from 'projects/trains/lib/order/getCoachesByCategory';
import {countPassengersWithPlaces} from 'projects/trains/lib/order/passengers/utils';
import getFirstForwardCoach from 'projects/trains/lib/complexOrder/getFirstForwardCoach';

import getFirstForwardTrain from '../complexOrder/getFirstForwardTrain';

export interface IUnexpectedOrderStates {
    seatsInSameCategory?: boolean;
    seatsInOtherCategory?: boolean;
    notEnoughSeatsInTrain?: boolean;
    orderPlacesMoreThanPassengers?: boolean;
}

export default function getUnexpectedStates(
    order: TrainsOrderStateInterface,
): IUnexpectedOrderStates | null {
    const {passengers} = order;
    const coach = getFirstForwardCoach(order);
    const train = getFirstForwardTrain(order);
    const orderPlaces = train?.orderPlaces ?? [];
    const coachCategory = train?.coachCategory;
    const trainDetailsInfo = train?.trainDetails;

    if (!trainDetailsInfo) {
        return null;
    }

    const {errors, trainDetails} = trainDetailsInfo;
    const unexpectedStates: IUnexpectedOrderStates = {};

    if (!errors && trainDetails && coach) {
        const {coaches} = trainDetails;

        const passengersWithPlaces = countPassengersWithPlaces(passengers);
        const categoryCoaches = coachCategory
            ? getCoachesByCategory(coaches, coachCategory)
            : [];

        if (coach.places.length < passengersWithPlaces) {
            if (
                categoryCoaches.find(
                    ({places}: ITrainsCoach) =>
                        places.length >= passengersWithPlaces,
                )
            ) {
                unexpectedStates.seatsInSameCategory = true;
            } else if (
                coaches.find(
                    ({places}) => places.length >= passengersWithPlaces,
                )
            ) {
                unexpectedStates.seatsInOtherCategory = true;
            } else {
                unexpectedStates.notEnoughSeatsInTrain = true;
            }
        }

        if (orderPlaces.length > passengersWithPlaces) {
            unexpectedStates.orderPlacesMoreThanPassengers = true;
        }
    }

    return Object.keys(unexpectedStates).length ? unexpectedStates : null;
}
