import {ITrainGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';
import ETrainDisplayReservationPlaceType from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ETrainDisplayReservationPlaceType';

export function hasPlacesWithPets(trainService: ITrainGenericService): boolean {
    return trainService.trainInfo.passengers.some(({ticket}) =>
        ticket?.places.some(
            ({type}) =>
                type ===
                ETrainDisplayReservationPlaceType.FOR_PASSENGER_WITH_PET,
        ),
    );
}
