import {ERestrictionType} from 'projects/trains/lib/order/fields/restrictions/types';

import {IStepRestriction} from 'projects/trains/lib/order/stepRestrictions/restrictions';

import * as i18n from 'i18n/trains-order-restrictions';

/**
 * Список ошибок для которых показываем сообщение
 */
const restrictionTypeSet = new Set([
    ERestrictionType.NOT_ENOUGH_PLACES,
    ERestrictionType.NOT_ENOUGH_PLACES_IN_CLASS,
    ERestrictionType.GENDER_NOT_SELECTED,
    ERestrictionType.NO_PASSENGERS_IN_ORDER,
    ERestrictionType.NOT_ENOUGH_GENDER_PLACES,
    ERestrictionType.SERVICE_CLASS_NOT_SELECTED,
    ERestrictionType.MORE_PASSENGERS_THAN_PLACES,
    ERestrictionType.LESS_PASSENGERS_THAN_PLACES,
    ERestrictionType.MORE_THAN_ONE_DISCOUNT_TICKET_PER_PERSON,
    ERestrictionType.MORE_THAN_ONE_TICKET_PER_PERSON,
    ERestrictionType.MAX_PASSENGERS_REACHED,
    ERestrictionType.ONLY_ONE_CHILDREN_IN_TWO_SEATER_COMPARTMENT,
    ERestrictionType.ONLY_CHILDREN_IN_MEETING_ROOM_COMPARTMENT,
    ERestrictionType.HAS_DIFFERENT_GENDER_IN_TRAINS,
]);

export const orderMessages = {
    has(restriction: IStepRestriction | undefined): boolean {
        if (!restriction) {
            return false;
        }

        return restrictionTypeSet.has(restriction.type);
    },

    get(restriction: IStepRestriction): string {
        const {type, payload} = restriction;

        switch (type) {
            case ERestrictionType.NOT_ENOUGH_PLACES:
                return i18n.notDashEnoughDashPlaces();

            case ERestrictionType.NOT_ENOUGH_PLACES_IN_CLASS:
                return i18n.notDashEnoughDashPlacesDashInDashCoaches();

            case ERestrictionType.GENDER_NOT_SELECTED:
                return i18n.genderDashNotDashSelected();
            case ERestrictionType.NO_PASSENGERS_IN_ORDER:
                return i18n.noDashPassengersDashInDashOrder();
            case ERestrictionType.NOT_ENOUGH_GENDER_PLACES:
                return i18n.notDashEnoughDashGenderDashPlaces();
            case ERestrictionType.SERVICE_CLASS_NOT_SELECTED:
                return i18n.serviceDashClassDashNotDashSelected();
            case ERestrictionType.MORE_PASSENGERS_THAN_PLACES: {
                if (typeof payload !== 'object' || !payload.count) {
                    return '';
                }

                return i18n.moreDashPassengersDashThanDashPlaces({
                    count: payload.count,
                });
            }
            case ERestrictionType.LESS_PASSENGERS_THAN_PLACES:
                if (typeof payload !== 'object' || !payload.count) {
                    return '';
                }

                return i18n.lessDashPassengersDashThanDashPlaces({
                    count: payload.count,
                });
            case ERestrictionType.MORE_THAN_ONE_DISCOUNT_TICKET_PER_PERSON:
                return i18n.multipleDashDiscountDashTicketsDashPerDashPerson();
            case ERestrictionType.MORE_THAN_ONE_TICKET_PER_PERSON:
                return i18n.multipleDashTicketsDashPerDashPerson();
            case ERestrictionType.MAX_PASSENGERS_REACHED:
                if (typeof payload !== 'object' || !payload.max) {
                    return '';
                }

                return i18n.maxDashPassengersDashReached({max: payload.max});
            case ERestrictionType.ONLY_ONE_CHILDREN_IN_TWO_SEATER_COMPARTMENT:
                return i18n.onlyDashOneDashChildrenDashInDashTwoDashSeaterDashCompartment();
            case ERestrictionType.ONLY_CHILDREN_IN_MEETING_ROOM_COMPARTMENT:
                return i18n.onlyDashChildrenDashInDashMeetingDashRoomDashCompartment();
            case ERestrictionType.HAS_DIFFERENT_GENDER_IN_TRAINS:
                return i18n.hasDifferentGenderInTrains();
            default:
                return '';
        }
    },
};
