import isEmpty from 'lodash/isEmpty';

import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';
import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {ITrainsRequirements, ITrainsCoach} from 'reducers/trains/order/types';

import isGenderCoach from 'projects/trains/lib/order/gender/isGenderCoach';

/**
 * Следующие 5 функций возвращают массив типа [bool, bool], где:
 * 0-й элемент говорит, было ли доступно данное требование пользователю
 * 1-й элемент -- было ли оно использовано
 */

/**
 * @param order - параметры заказа
 * @param order.coachType - тип вагона
 * @param order.requirements - требования к местам
 * @param type - необходимый тип вагона для выполнения условия
 * @param isVisible - видно ли индивидуальные параметры требований
 */
export const getDataForRelativeArrangementOfPlaces = (
    {
        coachType,
        requirements,
    }: {
        coachType: TRAIN_COACH_TYPE;
        requirements: ITrainsRequirements;
    },
    type: TRAIN_COACH_TYPE,
    isVisible: boolean,
): [boolean, boolean] => [
    coachType === type && isVisible,
    Boolean(requirements && requirements.arrangement),
];

/**
 * @param coachType - тип вагона
 * @param requirements - требования к местам
 * @param coachTypes - удовлетворяющие типы вагона
 */
export const getDataForCount = (
    {
        coachType,
        requirements,
    }: {
        coachType: TRAIN_COACH_TYPE;
        requirements: ITrainsRequirements;
    },
    coachTypes: TRAIN_COACH_TYPE[],
): [boolean, boolean] => [
    coachTypes.some(type => coachType === type),
    !isEmpty(requirements && requirements.count),
];

/**
 * @param twoStorey - наличие двух этажей в вагоне
 * @param requirements - требования к местам
 */
export const getDataForStoreyTrigger = (
    twoStorey: boolean,
    requirements: ITrainsRequirements,
): [boolean, boolean] => [
    twoStorey,
    Boolean(requirements && requirements.storey),
];

/**
 * @param coach - информация о вагоне
 * @param gender - информация о выбранном гендере купе
 */
export const getDataForGenderTrigger = (
    coach: ITrainsCoach,
    gender: GENDER_TYPE | null,
): [boolean, boolean] => [isGenderCoach(coach), Boolean(gender)];
