import isNumber from 'lodash/isNumber';

import {ITrainsCoach} from 'reducers/trains/order/types';
import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';
import {IMetrikaTrainsSearchPageInconsistencyParams} from 'utilities/metrika/types/params/trains';

import {params} from 'utilities/metrika';
import getTariffsInconsistency from 'projects/trains/lib/order/tariffsConsistency/getTariffsInconsistency';

/*
 * Функция записывает в параметры визита расхождение по тарифам актуальных данных и того, что берется из сегмента
 */
export default function setVisitParamsInconsistentTariffs(
    coaches: ITrainsCoach[],
    segment: TTrainsStoreOrderSegment,
): void {
    const {minPriceDifference, placeDifference} = getTariffsInconsistency(
        coaches,
        segment,
    );

    const roundedMinPriceDifference = Math.round(minPriceDifference);

    const visitParams: IMetrikaTrainsSearchPageInconsistencyParams = {};

    if (isNumber(minPriceDifference) && roundedMinPriceDifference > 0) {
        visitParams.searchPagePriceInconsistency = roundedMinPriceDifference;
    }

    if (isNumber(placeDifference) && placeDifference > 0) {
        visitParams.searchPagePlaceInconsistency = placeDifference;
    }

    if (Object.keys(visitParams).length) {
        params({
            trains: {
                ...visitParams,
            },
        });
    }
}
