import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {TrainsOrderStateInterface} from 'reducers/trains/order/reducer';

const INITIAL_STEPS = [ORDER_STEP.PLACES, ORDER_STEP.PASSENGERS];

/**
 * Функция определяет необходимо ли делать отмену брони при переходе на определенный шаг оплаты
 *
 * @param order - данные заказа
 */
export default function needToCancelOrder(
    order: TrainsOrderStateInterface,
): boolean {
    const {orderStep, orderInfo} = order;

    return orderInfo?.id ? INITIAL_STEPS.includes(orderStep) : false;
}
