import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {TrainsOrderStateInterface} from 'reducers/trains/order/reducer';

export function isOrderStepAfterReserve(orderStep: ORDER_STEP): boolean {
    return orderStep === ORDER_STEP.CONFIRM || orderStep === ORDER_STEP.PAYMENT;
}

/**
 * Метод проверки состояния заказа
 * Проверяем также шаг покупки, т.к. отмена брони работает асинхронно
 *
 * @param order - кусок стора
 */
export function orderIsReserved(
    order: Pick<TrainsOrderStateInterface, 'orderInfo' | 'orderStep'>,
): boolean {
    const {orderInfo, orderStep} = order;

    return Boolean(orderInfo?.state) && isOrderStepAfterReserve(orderStep);
}
