import _flatten from 'lodash/flatten';

import {isNotNullable} from 'types/utilities';
import {
    TFormPassengers,
    IPassenger,
} from 'types/trains/booking/ITrainsBookFormValues';

export function flatMapPassengers<T>(
    formPassengers: TFormPassengers,
    callback: (passenger: IPassenger) => T,
): T[] {
    const passengers = _flatten(Object.values(formPassengers)).filter(
        isNotNullable,
    );

    return passengers.map(callback);
}
