import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

import {ITrainPassenger} from 'reducers/trains/order/types';

import {getPassengerHash} from 'projects/trains/lib/order/passengers/getPassengerHash';
import getPassengersDict from 'projects/trains/lib/order/passengers/getPassengersDict';
import getPassengersData from 'projects/trains/lib/order/passengers/getPassengersData';

interface IGetMergedPassengersDataParams {
    passengersData: ITrainPassenger[];
    allowedDocumentTypes: TRAINS_DOCUMENT_TYPES[];
}

/**
 * Возвращает массив данных пассажиров с объединенными полями
 * для пассажиров с одинаковыми персональными данными
 */
export default function getMergedPassengersData(
    params: IGetMergedPassengersDataParams,
): ITrainPassenger[] {
    const passengers = getPassengersData(params);
    const dict = getPassengersDict(passengers);

    return passengers.map(passenger => dict[getPassengerHash(passenger)]);
}
