import moment, {Moment} from 'moment';

import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';

/**
 * Функция возвращает возраст пассажира на заданный момент.
 * День рождения считаем по таймзоне устройства.
 *
 * @param birthDate - дата рождения в формате 01.04.2021
 * @param date - момент на который считать возраст
 */
export default function getPassengerAge(
    birthDate: string,
    date: Moment,
): number {
    return date.diff(
        moment(birthDate, HUMAN_DATE_RU).utcOffset(date.utcOffset(), true),
        'years',
        true,
    );
}
