import {RU_GEO_ID} from 'constants/common';
import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';
import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';

import {ITrainPassenger} from 'reducers/trains/order/types';

import {DEFAULT_STATE} from 'reducers/trains/order/reducers/bonusCards';

import {getDefaultDocumentType} from 'projects/trains/lib/order/passengers/documentTypes';

/**
 * Метод обработки пассажирских данных
 * Подставляет дефолтные значения в пустые поля и изменяет несовместимые данные
 * @param passenger - данные пассажира
 * @param allowedDocumentTypes - допустимые типы документов

 */
export default function getPassengerData(
    passenger: ITrainPassenger,
    allowedDocumentTypes: TRAINS_DOCUMENT_TYPES[],
): ITrainPassenger {
    let {bonusCards, passengerDocument} = passenger;
    const documentType = passengerDocument.type.value;

    // Если тип документа не был выбран подставляем дефолтный
    if (!documentType) {
        const defaultDocumentType = getDefaultDocumentType(
            passenger.ageGroup,
            allowedDocumentTypes,
        );

        passengerDocument = {
            ...passengerDocument,
            type: {
                value: defaultDocumentType,
            },
            country: {
                value:
                    defaultDocumentType ===
                    TRAINS_DOCUMENT_TYPES.FOREIGN_DOCUMENT
                        ? undefined
                        : RU_GEO_ID,
            },
        };
    }

    // Пункт из чек-листа 5.36.4 Поле для ввода карты должно быть неактивным  для типа документа ВБ
    if (documentType === TRAINS_DOCUMENT_TYPES.MILITARY_CARD) {
        bonusCards = DEFAULT_STATE;
    }

    if (documentType === TRAINS_DOCUMENT_TYPES.BIRTH_CERTIFICATE) {
        // Требование ИМ: Не давать вводить Дорожную карту для свидетельства о рождении (https://st.yandex-team.ru/RASPFRONT-4050)
        delete bonusCards[TRAIN_BONUS_CARDS.ROAD_CARD];
    }

    return {...passenger, bonusCards, passengerDocument};
}
