import get from 'lodash/get';

import {ITrainPassenger} from 'reducers/trains/order/types';

export const FIRST_NAME_KEY = 'firstName';
export const LAST_NAME_KEY = 'lastName';
export const PATRONYMIC_KEY = 'patronymic';
export const BIRTH_DATE_KEY = 'birthDate';

const DOCUMENT_NUMBER_KEY = 'passengerDocument.number';

const HASH_FIELD = [
    FIRST_NAME_KEY,
    LAST_NAME_KEY,
    PATRONYMIC_KEY,
    BIRTH_DATE_KEY,
    DOCUMENT_NUMBER_KEY,
];

/**
 * Метод определяет заполнены ли все поля участвующие в построении хеша
 *
 * @param passenger - данные пассажира
 * @param excludeFields - поля которые необходимо исключить при создании хэша
 */
export function areAllHashFieldsFilled(
    passenger: ITrainPassenger,
    excludeFields: string[] = [],
): boolean {
    const fields = HASH_FIELD.filter(path => !excludeFields.includes(path));
    const filledFields = fields.filter(path =>
        get(passenger, `${path}.value`, ''),
    );

    return fields.length === filledFields.length;
}

/**
 * Метод возвращает хеш по данным пассажира
 *
 * @param passenger - данные пассажира
 * @param excludeFields - поля которые необходимо исключить при создании хэша
 */
export function getPassengerHash(
    passenger: ITrainPassenger,
    excludeFields: string[] = [],
): string {
    return HASH_FIELD.filter(path => !excludeFields.includes(path))
        .map(path => get(passenger, `${path}.value`, '').replace(/\./g, '/'))
        .filter(Boolean)
        .join('-');
}
