import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {IStoreTrainTravelerPassenger} from 'reducers/trains/order/types';
import {ITrainsTariffCategory} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {getAgeGroup} from 'projects/trains/lib/order/fields/birthDate';
import {getBoardingAge} from 'utilities/dateUtils/getBoardingAge';

/**
 * Функция возвращает отфлильтрованных по возврастной группе пассажиров
 *
 * @param passengers - пассажиры
 * @param ageGroup - возрастная группа для фильтрации
 * @param lastSegmentDeparture - дата отправления последнего сегмента
 * @param tariffCategories - возрастные категории
 */
export default function getPassengersByAgeGroup({
    passengers,
    ageGroup,
    lastSegmentDeparture,
    tariffCategories,
}: {
    passengers: IStoreTrainTravelerPassenger[];
    ageGroup: PASSENGERS_TYPES;
    lastSegmentDeparture: string;
    tariffCategories: ITrainsTariffCategory[];
}): IStoreTrainTravelerPassenger[] {
    return passengers.filter(passenger => {
        const {
            birthDate: {value: birthDateValue},
        } = passenger;

        if (!birthDateValue) {
            return false;
        }

        const boardingAge = getBoardingAge(
            birthDateValue,
            lastSegmentDeparture,
        );
        const passengerAgeGroup = getAgeGroup(boardingAge, tariffCategories);

        return passengerAgeGroup === ageGroup;
    });
}
