import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

import {ITrainPassenger} from 'reducers/trains/order/types';

import getPassengerData from 'projects/trains/lib/order/passengers/getPassengerData';

interface IGetPassengersDataParams {
    passengersData: ITrainPassenger[];
    allowedDocumentTypes: TRAINS_DOCUMENT_TYPES[];
}

/**
 * Возвращает подготовленные данные пассажиров
 * @param order - данные о заказе
 */
export default function getPassengersData({
    passengersData,
    allowedDocumentTypes,
}: IGetPassengersDataParams): ITrainPassenger[] {
    return passengersData.map(data =>
        getPassengerData(data, allowedDocumentTypes),
    );
}
