import isObject from 'lodash/isObject';
import mergeWith from 'lodash/mergeWith';

import {ITrainPassenger} from 'reducers/trains/order/types';

import {makeCacheable} from 'projects/trains/lib/cache';
import {getPassengerHash} from 'projects/trains/lib/order/passengers/getPassengerHash';

/**
 * Получаем словарик пассажиров
 * (мержит пассажиров с одинаковыми персональными данными в один объект)
 * @param {Object[]} passengers - данные пассажиров
 */
const getPassengersDict: (
    passengers: ITrainPassenger[],
) => Record<string, ITrainPassenger> = makeCacheable(
    (passengers: ITrainPassenger[]) =>
        passengers.reduce((dict, passenger) => {
            const hash = getPassengerHash(passenger);
            const hashData = dict[hash] || {};

            return {
                ...dict,
                [hash]: {
                    ...mergeWith(hashData, passenger, (objValue, srcValue) => {
                        if (!isObject(objValue) && !isObject(srcValue)) {
                            return objValue || srcValue;
                        }

                        return undefined;
                    }),
                },
            };
        }, {} as Record<string, ITrainPassenger>),
);

export default getPassengersDict;
