import intersection from 'lodash/intersection';

import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

import {
    IAdditionalSchemeInfo,
    ITrainPassenger,
    ITrainsCoach,
    TrainsPassengersCount,
} from 'reducers/trains/order/types';

import getMergedPassengersData from 'projects/trains/lib/order/passengers/getMergedPassengersData';
import {getPlacesSortedByPrice} from 'projects/trains/lib/order/getPlacesSortedByPrice';

interface IGetPassengersForOrderParams {
    allowedDocumentTypes: TRAINS_DOCUMENT_TYPES[];
    passengers: TrainsPassengersCount;
    passengersData: ITrainPassenger[];
    orderPlaces: number[];
    nonRefundablePlaces: number[];
    coach: ITrainsCoach | null;
    additionalSchemeInfo: IAdditionalSchemeInfo[];
    nonRefundableTariff: boolean;
    beddingOption: boolean;
}

/**
 * Возвращает массив данных пассажиров для заказа
 */
export default function getPassengersForOrder(
    params: IGetPassengersForOrderParams,
): ITrainPassenger[] {
    const {
        passengers,
        orderPlaces,
        nonRefundablePlaces,
        coach,
        additionalSchemeInfo,
        nonRefundableTariff,
        beddingOption,
        allowedDocumentTypes,
        passengersData,
    } = params;

    const allPlaces = getPlacesSortedByPrice({
        passengers,
        orderPlaces,
        coach,
        additionalSchemeInfo,
        nonRefundableTariff,
        beddingOption,
    });
    const mergedPassengers = getMergedPassengersData({
        passengersData,
        allowedDocumentTypes,
    });

    return mergedPassengers.map((passenger, index) => ({
        ...passenger,
        isNonRefundableTariff: Boolean(
            intersection(allPlaces[index], nonRefundablePlaces).length,
        ),
    }));
}
