import {TrainsPassengersCount} from 'reducers/trains/order/types';

import {getStorageItem, saveStorageItem} from 'utilities/storageUtils';

const storage =
    typeof window === 'undefined' ? undefined : window?.sessionStorage;
const STORAGE_PASSENGERS_COUNT_KEY = 'trains_order_passengers_count';

export function getTrainsStoredPassengersCount(
    isCppk: boolean,
): Nullable<TrainsPassengersCount> {
    const storedValue = getStorageItem(storage, STORAGE_PASSENGERS_COUNT_KEY);

    return storedValue && storedValue.isCppk === isCppk
        ? storedValue.passengers
        : null;
}

export function saveTrainsPassengersCount(
    passengers: TrainsPassengersCount,
    isCppk: boolean,
): void {
    saveStorageItem(storage, STORAGE_PASSENGERS_COUNT_KEY, {
        isCppk,
        passengers,
    });
}
