import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {TrainsPassengersCount} from 'reducers/trains/order/types';
import {ERestrictionType} from 'projects/trains/lib/order/fields/restrictions/types';

import {
    createRestriction,
    prioritizeRestrictions,
} from 'projects/trains/lib/restrictions';

const minAdults = createRestriction<TrainsPassengersCount, boolean>(
    ERestrictionType.MIN_ADULTS,
    state => state[PASSENGERS_TYPES.ADULTS] < 0,
);

const minChildren = createRestriction<TrainsPassengersCount, boolean>(
    ERestrictionType.MIN_CHILDREN,
    state => state[PASSENGERS_TYPES.CHILDREN] < 0,
);

const minBabies = createRestriction<TrainsPassengersCount, boolean>(
    ERestrictionType.MIN_BABIES,
    state => state[PASSENGERS_TYPES.BABIES] < 0,
);

const maxPassengers = createRestriction<TrainsPassengersCount, boolean>(
    ERestrictionType.MAX_PASSENGERS,
    state =>
        state[PASSENGERS_TYPES.ADULTS] +
            state[PASSENGERS_TYPES.CHILDREN] +
            state[PASSENGERS_TYPES.BABIES] >
        4,
);

const adultsOverBabies = createRestriction<TrainsPassengersCount, boolean>(
    ERestrictionType.ADULTS_OVER_BABIES,
    state => state[PASSENGERS_TYPES.ADULTS] < state[PASSENGERS_TYPES.BABIES],
);

export const passengersRestrictions = prioritizeRestrictions([
    minAdults,
    minChildren,
    minBabies,
    maxPassengers,
    adultsOverBabies,
]);
