import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {TrainsPassengersCount} from 'reducers/trains/order/types';

export const countPassengers = (passengers: TrainsPassengersCount): number =>
    passengers[PASSENGERS_TYPES.ADULTS] +
    passengers[PASSENGERS_TYPES.CHILDREN] +
    passengers[PASSENGERS_TYPES.BABIES];

export const countPassengersWithPlaces = (
    passengers: TrainsPassengersCount,
): number =>
    passengers[PASSENGERS_TYPES.ADULTS] + passengers[PASSENGERS_TYPES.CHILDREN];

export const countPassengersWithoutPlaces = (
    passengers: TrainsPassengersCount,
): number => passengers[PASSENGERS_TYPES.BABIES];
