import {
    PLATZKARTE,
    COMPARTMENT,
    SUITE,
    SITTING,
    COMMON,
    SOFT,
} from 'projects/trains/lib/segments/tariffs/constants';

import {ITrainsSchema} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';
import {TrainsOrderCompartmentGender} from 'server/api/TrainsBookingApi/types/TrainsOrderCompartmentGender';

export const TYPE_CATEGORIES_MAP = {
    [PLATZKARTE]: {
        bottom: {
            upper: false,
            side: false,
        },
        top: {
            upper: true,
            side: false,
        },
        'bottom-side': {
            upper: false,
            side: true,
        },
        'top-side': {
            upper: true,
            side: true,
        },
    },

    [COMPARTMENT]: {
        bottom: {upper: false},
        top: {upper: true},
    },

    [SUITE]: {
        bottom: {upper: false},
        top: {upper: true},
    },

    [SITTING]: {
        regular: {
            nearTable: false,
            folding: false,
        },
        'near-table': {
            nearTable: true,
            folding: false,
        },
        folding: {folding: true},
    },

    [COMMON]: {
        regular: {side: false},
        side: {side: true},
    },

    [SOFT]: {
        bottom: {upper: false},
        top: {upper: true},
    },
};

/**
 * Возвращает признак ярусности вагона
 *
 * @param schema - схема вагона
 */
export function isStoreysCoach(schema?: ITrainsSchema): boolean {
    return Boolean(schema?.placeFlags?.upper?.length);
}

/**
 * Возвращает признак является ли отсек гендерным
 *
 * @param compartmentGender
 */
export function isGenderCompartment(
    compartmentGender: TrainsOrderCompartmentGender | null,
): boolean {
    return (
        compartmentGender === TrainsOrderCompartmentGender.MALE ||
        compartmentGender === TrainsOrderCompartmentGender.FEMALE
    );
}
