import {ITrainsSchema} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';
import {ITrainsCoach} from 'reducers/trains/order/types';

import {IPlaceMapItem} from 'projects/trains/lib/order/getPlaceMap';

export const RESERVED = 'reserved';
export const AVAILABLE = 'available';
export const SELECTED = 'selected';
export const UNAVAILABLE = 'unavailable';

export const PLACE_STATES = [RESERVED, AVAILABLE, SELECTED, UNAVAILABLE];

/**
 * Возвращает массив мест со статусами (выбрано, доступно для выбора, недоступно для выбора, занято)
 *
 * @param schema - схема вагона
 * @param coach - данные вагона из trainDetails
 * @param reservedPlaces - массив забронированных мест
 */
export function getConfirmationPlaceMap({
    schema,
    coach,
    reservedPlaces,
}: {
    schema: ITrainsSchema;
    coach: ITrainsCoach;
    reservedPlaces: string[];
}): IPlaceMapItem[] {
    if (!schema) {
        return [];
    }

    const {genderTipUp = []} = schema.placeFlags;

    return schema.places.map((place): IPlaceMapItem => {
        const {number} = place;
        const coachPlace = coach.places.find(item => item.number === number);

        return {
            ...place,
            placeState: reservedPlaces.includes(String(number))
                ? SELECTED
                : coachPlace
                ? UNAVAILABLE
                : RESERVED,
            gender: (coachPlace && coachPlace.gender) || null,
            genderTipUp: genderTipUp.includes(number),
            theme: null,
            tariff: null,
            upper: false,
        };
    });
}
