import {PLACE_RESERVATION_TYPE} from 'projects/trains/constants/placeReservationType';

/**
 * Возвращает максимальное количество мест, которое можно купить в зависимости от типа резервирования мест.
 *
 * @param placeReservationType - Тип выкупа мест.
 */
export default function getMaxPlacesReservationCountByType(
    placeReservationType: PLACE_RESERVATION_TYPE,
): number {
    if (placeReservationType === PLACE_RESERVATION_TYPE.TWO_PLACES_AT_ONCE) {
        return 2;
    }

    // в том числе и для PLACE_RESERVATION_TYPE.FOUR_PLACES_AT_ONCE
    return 4;
}
