import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {ITrainsCoachPlace} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';
import {ITrainsCoachPriceWithoutPlaces} from 'types/trains/booking/coach/ITrainsCoachPriceWithoutPlaces';

/**
 * Функция возвращает минимальные цены для мест, сгруппированные по возрастным группам
 *
 * @param places - места вагона
 * @param priceWithoutPlaces - цена для случая, когда нет информации о местах
 */
export default function getMinPlacesPricesGroupedByAgeGroups({
    places,
    priceWithoutPlaces,
}: {
    places: ITrainsCoachPlace[];
    priceWithoutPlaces?: ITrainsCoachPriceWithoutPlaces;
}): {
    [PASSENGERS_TYPES.ADULTS]: number;
    [PASSENGERS_TYPES.CHILDREN]: number;
} {
    if (
        !places.length &&
        priceWithoutPlaces?.adultTariff &&
        priceWithoutPlaces?.childTariff
    ) {
        const {adultTariff, childTariff} = priceWithoutPlaces;

        return {
            [PASSENGERS_TYPES.ADULTS]: adultTariff.value,
            [PASSENGERS_TYPES.CHILDREN]: childTariff.value,
        };
    }

    return places.reduce(
        (tariffPriceMap, place) => {
            const {adultTariff, childTariff} = place;

            if (adultTariff.value < tariffPriceMap[PASSENGERS_TYPES.ADULTS]) {
                tariffPriceMap[PASSENGERS_TYPES.ADULTS] = adultTariff.value;
            }

            if (childTariff.value < tariffPriceMap[PASSENGERS_TYPES.CHILDREN]) {
                tariffPriceMap[PASSENGERS_TYPES.CHILDREN] = childTariff.value;
            }

            return tariffPriceMap;
        },
        {
            [PASSENGERS_TYPES.ADULTS]: Infinity,
            [PASSENGERS_TYPES.CHILDREN]: Infinity,
        },
    );
}
