import {
    ITrainsCoach,
    IReservationVariant,
    TrainsPassengersCount,
} from 'reducers/trains/order/types';

/**
 * Возвращает цену за купе в вагоне, где нужно выкупать купе целиком.
 * Если вариантов размещения нет (например, количество пассажиров больше, чем можно купить мест в купе),
 * то возвращается максимальная цена.
 *
 * @param coach
 * @param passengers
 */
export default function getSuitableReservationVariantPrice(
    coach: ITrainsCoach,
    passengers: TrainsPassengersCount,
): number {
    if (coach.reservationVariants && coach.reservationVariants.length > 0) {
        let maxPrice = -Infinity;
        let suitablePrice = 0;

        coach.reservationVariants.forEach(
            (reservationVariant: IReservationVariant) => {
                if (
                    reservationVariant.passengers.baby === passengers.babies &&
                    reservationVariant.passengers.child ===
                        passengers.children &&
                    reservationVariant.passengers.full === passengers.adults &&
                    !reservationVariant.giveChildWithoutPlace
                ) {
                    suitablePrice = reservationVariant.amount;
                }

                if (reservationVariant.amount > maxPrice) {
                    maxPrice = reservationVariant.amount;
                }
            },
        );

        return suitablePrice || (maxPrice > 0 ? maxPrice : 0);
    }

    return 0;
}
