import {PRICE_PALETTE_THEMES} from 'projects/trains/constants/pricePalette';

import {
    IPriceDivision,
    IPriceDivisionWithTheme,
} from 'projects/trains/lib/order/priceScale/types';
import {EPricePalette} from 'types/trains/booking/EPricePalette';

const MIN_DIVISION_WEIGHT = 2;
const MAX_DIVISION_WEIGHT = 5;

/**
 * Вернёт признак того, что к разбиению возможно применить раскраску
 *
 * @param division - массив с разбиениями
 */
export function isValidDivision(
    division: (IPriceDivision | IPriceDivisionWithTheme)[],
): boolean {
    const divisionWeight = division.length;

    return (
        divisionWeight >= MIN_DIVISION_WEIGHT &&
        divisionWeight <= MAX_DIVISION_WEIGHT
    );
}

function getPalette(division: IPriceDivision[]): EPricePalette[] {
    const divisionWeight = division.length;

    return PRICE_PALETTE_THEMES[divisionWeight - MIN_DIVISION_WEIGHT];
}

/**
 * Задает раскраску для разбиений
 * @param division - массив с разбиениями
 */
export default function colorizeDivision(
    division: IPriceDivision[],
): (IPriceDivision | IPriceDivisionWithTheme)[] {
    if (!isValidDivision(division)) {
        return division;
    }

    const palette = getPalette(division);

    return division.map((item, index) => ({
        ...item,
        theme: palette[index],
    }));
}
