import {ITrainsCoach} from 'reducers/trains/order/types';
import {IPriceDivision} from 'projects/trains/lib/order/priceScale/types';

import getCoachesInfo from 'projects/trains/lib/order/getCoachesInfo';

const GROUPING_LIMIT = 50; // Цены с разбросом в 50 группируются в одну категорию

/**
 * Построние разбиения по цене
 * Разбиение не идеальное, но оно соответствует тому разбиению по
 * которому строилась аналитика по этой задаче
 *
 * @param coaches - список вагонов
 * @param beddingOption - признак использования белья
 */
export default function countDivision(
    coaches: ITrainsCoach[],
    beddingOption: boolean,
): IPriceDivision[] {
    const {prices} = getCoachesInfo(coaches, beddingOption);

    return [...new Set(prices.map(({value}) => value))]
        .sort((a, b) => a - b)
        .reduce<IPriceDivision[]>((acc, price) => {
            const division = acc[acc.length - 1];
            const {values = []} = division || {};
            const baseValue = values[0] as typeof values[0] | undefined;

            if (baseValue === undefined || price - baseValue > GROUPING_LIMIT) {
                acc.push({
                    values: [price],
                    theme: null,
                });
            } else {
                values.push(price);
            }

            return acc;
        }, []);
}
