import {TTrainsOrderSelectorSegment} from 'projects/trains/lib/segments/types';

import {FeaturesState} from 'reducers/common/commonReducerTypes';

import isUssrThread from 'projects/trains/lib/segments/isUssrThread';
import isAbroadThread from 'projects/trains/lib/segments/isAbroadThread';
import {isUkrainianSegment} from 'projects/trains/lib/segments/isUkranianSegment';

/**
 * Индикатор, показываем ли мы новую страницу покупки.
 * RASPFRONT-2671
 *
 * @param segment - сегмент выдачи
 * @param features - флаги экспериментов
 */
export function shouldUseOwnOrderPage(
    segment: TTrainsOrderSelectorSegment,
    features: FeaturesState = {},
): boolean {
    if (features.skipSalesCheck) {
        return true;
    }

    // хак, чтобы не редиректило для покупки пересадок
    if ('isTransferSubSegment' in segment) {
        return true;
    }

    const thread = 'thread' in segment ? segment.thread : null;

    if (
        !thread ||
        ('oldUfsOrder' in segment && segment.oldUfsOrder) ||
        isUkrainianSegment(segment)
    ) {
        return false;
    }

    if (features.trainsAllowInternationalRoutes) {
        return isUssrThread(thread) || isAbroadThread(thread);
    }

    return isUssrThread(thread);
}
