import sortBy from 'lodash/sortBy';

import {ITrainsCoach} from 'reducers/trains/order/types';

export default function sortCoaches(coaches: ITrainsCoach[]): ITrainsCoach[] {
    return sortBy(coaches, coach => {
        const {places, placeCounts} = coach;

        if (places && places.length) {
            return places.reduce(
                (weight, {adultTariff}) => weight + 100 / adultTariff.value,
                0,
            );
        } else if (placeCounts && placeCounts.total && coach.adultTariff) {
            return (100 / coach.adultTariff.value) * placeCounts.total;
        }

        return 0;
    });
}
