import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {ERestrictionType} from 'projects/trains/lib/order/fields/restrictions/types';
import {IStepRestrictionsData} from 'projects/trains/lib/order/stepRestrictions/types/IStepRestrictionsData';

import placesRestrictions from 'projects/trains/lib/order/stepRestrictions/placesRestrictions';
import passengersRestrictions from 'projects/trains/lib/order/stepRestrictions/passengersRestrictions';

export interface IStepRestriction {
    type: ERestrictionType;
    payload:
        | {
              count?: number;
              max?: number;
          }
        | boolean
        | undefined;
}

const ORDER_STEP_RESTRICTIONS = {
    [ORDER_STEP.PLACES]: placesRestrictions,
    [ORDER_STEP.PASSENGERS]: passengersRestrictions,
};

export function getRestrictions(
    orderStep: ORDER_STEP,
): (state: IStepRestrictionsData) => IStepRestriction[] {
    if (
        orderStep === ORDER_STEP.PLACES ||
        orderStep === ORDER_STEP.PASSENGERS
    ) {
        return ORDER_STEP_RESTRICTIONS[orderStep];
    }

    return (_): IStepRestriction[] => [];
}
