import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';
import {GENDER_TYPE} from 'projects/trains/constants/genders';
import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {EDirection} from 'types/common/EDirection';
import {
    IAdditionalSchemeInfo,
    ITrainPassenger,
    ITrainsCoach,
    TrainsPassengersCount,
} from 'reducers/trains/order/types';
import {EPlacesView} from 'types/trains/booking/EPlacesView';

import {TOrderStepDescription} from 'reducers/trains/order/thunk/changeOrderStep';

export interface IStepRestrictionsData {
    /**
     * Направление движения текущего поезда
     */
    direction: EDirection;
    /**
     * Индекс поезда в маршруте поездов
     */
    index: number;

    /**
     * Следующий шаг покупки
     */
    nextStep: TOrderStepDescription;

    /**
     * Количество пассажиров
     */
    passengers: TrainsPassengersCount;
    /**
     * Данные формы с количеством пассажиров
     */
    passengersData: ITrainPassenger[];

    /**
     * Доступные документы для всех поездов
     */
    allowedDocumentTypes: TRAINS_DOCUMENT_TYPES[];
    /**
     * Признак поставщика ЦППК для всех поездов
     */
    isCppk: boolean;

    /**
     * Выбранный пол купе в текущем поезде
     */
    gender: GENDER_TYPE | null;

    /**
     * В заказе указан различный пол между поездами
     * например в первом поезде выбрано мужское купе, а во втором женское
     */
    hasDifferentGenderInTrains: boolean;

    /**
     * Выбранный вагон в текущем поезде
     */
    coach: ITrainsCoach | null;
    /**
     * Выбранный класс в текущем поезде
     */
    expandedServiceClass: string | null;
    /**
     * Выбранные места в текущем поезде
     */
    orderPlaces: number[];
    /**
     * Выбранный тип выбора мест (схема/требования) в текущем поезде
     */
    placesViewType: EPlacesView | undefined;
    /**
     * Выбранный тип вагона в текущем поезде
     */
    coachType: TRAIN_COACH_TYPE | null;
    /**
     * Дополнительная информация о схеме в текущем поезде
     */
    additionalSchemeInfo: IAdditionalSchemeInfo[];
}
