import groupBy from 'lodash/groupBy';

import {ITrainsCoach} from 'reducers/trains/order/types';

import getCoachesInfo from 'projects/trains/lib/order/getCoachesInfo';
import {memoizeOne} from 'utilities/functions/memoizeOne';
import IPrice from 'utilities/currency/PriceInterface';

/**
 * Вернет сгрупированные цены по каждому coach.type или coach.category
 */
const getCoachTypesData = memoizeOne(
    (
        coaches: ITrainsCoach[],
        groupByCategory: boolean = false,
    ): Record<string, {count: number; prices: IPrice[]}> => {
        const coachesByType = groupBy(
            coaches,
            groupByCategory ? (item): string => item.category.value : 'type',
        );

        return Object.keys(coachesByType).reduce<
            Record<string, {count: number; prices: IPrice[]}>
        >(
            (coachTypes, coachType) => ({
                ...coachTypes,
                [coachType]: getCoachesInfo(coachesByType[coachType]),
            }),
            {},
        );
    },
);

export default getCoachTypesData;
