import {ITrainsCoachTariff} from 'reducers/trains/order/types';

/**
 * Сортирует тарифы, чтобы правильно происходил поиск подходящего тарифа.
 *
 * @param tariffs - тарифы.
 */
export function trainsSortCoachTariffs(
    tariffs: ITrainsCoachTariff[],
): ITrainsCoachTariff[] {
    return tariffs.sort((tariffA, tariffB) => {
        if (tariffA.maxAge < tariffB.maxAge) {
            return -1;
        }

        if (tariffA.minAge < tariffB.minAge) {
            return 1;
        }

        if (tariffA.maxAge > tariffB.maxAge) {
            return 1;
        }

        if (tariffA.minAge > tariffB.minAge) {
            return -1;
        }

        return Number(tariffB.needDocument) - Number(tariffA.needDocument);
    });
}
