import {
    IStoreTrainTravelerPassenger,
    IStoreTravelerPassengerDocument,
    ITrainPassenger,
} from 'reducers/trains/order/types';

/**
 * Функция проверяет совпадает ли пассажир и документ записной книжки с пассажиром из заказа
 *
 * @param  travelerPassenger - пассажир из записной книжки
 * @param travelerDocument - документ из записной книжки
 * @param storePassenger - пассажир из заказа
 */
export default function areTravelerAndStorePassengersEqual({
    travelerPassenger,
    travelerDocument,
    storePassenger,
}: {
    storePassenger: ITrainPassenger;
    travelerDocument: IStoreTravelerPassengerDocument;
    travelerPassenger: IStoreTrainTravelerPassenger;
}): boolean {
    return (
        travelerDocument.firstName.value === storePassenger.firstName.value &&
        travelerDocument.lastName.value === storePassenger.lastName.value &&
        travelerDocument.patronymic.value === storePassenger.patronymic.value &&
        travelerPassenger.gender.value === storePassenger.gender.value &&
        travelerPassenger.birthDate.value === storePassenger.birthDate.value &&
        travelerDocument.type.value ===
            storePassenger.passengerDocument.type.value &&
        travelerDocument.number.value ===
            storePassenger.passengerDocument.number.value &&
        travelerDocument.country.value ===
            storePassenger.passengerDocument.country.value
    );
}
