import invert from 'lodash/invert';

import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';

import {EBonusCardType} from 'server/api/TravelersApi/enums/EBonusCardType';

export const LOYALTY_CARDS_ORDER_TO_TRAVELER_MATCH: Record<
    TRAIN_BONUS_CARDS,
    EBonusCardType
> = {
    [TRAIN_BONUS_CARDS.BONUS_CARD]: EBonusCardType.RZD_BONUS,
    [TRAIN_BONUS_CARDS.ROAD_CARD]: EBonusCardType.UNIVERSAL_ROAD,
};

export const LOYALTY_CARDS_TRAVELER_TO_ORDER_MATCH = invert(
    LOYALTY_CARDS_ORDER_TO_TRAVELER_MATCH,
);
