import {LOYALTY_CARDS_TRAVELER_TO_ORDER_MATCH} from 'projects/trains/lib/order/traveler/constants';
import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';

import ITrainsCreateOrderLoyaltyCard from 'server/api/TrainsBookingApi/types/ITrainsCreateOrderLoyaltyCard';
import {IBonusCardDTO} from 'server/api/TravelersApi/types/IBonusCardDTO';

/**
 * Функция преобразует данные карт лояльности пассажиров путешественника для удобной дальнейшей работы с ними.
 *
 * @param serverPassengerLoyaltyCards - карты лояльности из записной книжки
 */
export function getPatchedTravelerLoyaltyCards(
    serverPassengerLoyaltyCards: IBonusCardDTO[],
): ITrainsCreateOrderLoyaltyCard[] {
    return serverPassengerLoyaltyCards.reduce<ITrainsCreateOrderLoyaltyCard[]>(
        (patchedPassengerLoyaltyCards, passengerLoyaltyCard) => {
            const loyaltyCard = {
                ...passengerLoyaltyCard,
                type: LOYALTY_CARDS_TRAVELER_TO_ORDER_MATCH[
                    passengerLoyaltyCard.type
                ] as TRAIN_BONUS_CARDS,
            };

            const sameTypeLoyaltyCardIndex =
                patchedPassengerLoyaltyCards.findIndex(
                    ({type}) => type === loyaltyCard.type,
                );

            // Если карта такого типа уже есть, то заменяем ее на новую
            if (sameTypeLoyaltyCardIndex !== -1) {
                patchedPassengerLoyaltyCards[sameTypeLoyaltyCardIndex] =
                    loyaltyCard;
            } else {
                patchedPassengerLoyaltyCards.push(loyaltyCard);
            }

            return patchedPassengerLoyaltyCards;
        },
        [],
    );
}
