import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

import {IDocumentDTO} from 'server/api/TravelersApi/types/IDocumentDTO';
import {IStoreTravelerPassengerDocument} from 'reducers/trains/order/types';

import {DOCUMENT_TYPE_BY_TRAVELER_DOCUMENT_TYPE} from 'projects/trains/lib/order/passengers/documentTypes';
import getTravelerPatronymic from 'projects/trains/lib/order/traveler/patchServerResponse/getTravelerPatronymic';

/**
 * Функция преобразует ответ ручки для дальнейшего удобства работы с документами пассажира
 *
 * @param passengerDocuments – документы пассажира записной книжки
 */
export function getPatchedTravelerPassengerDocuments(
    passengerDocuments: IDocumentDTO[],
): IStoreTravelerPassengerDocument[] {
    return passengerDocuments.map(document => {
        const firstName = document.first_name || document.first_name_en || '';
        const lastName = document.last_name || document.last_name_en || '';
        const patronymic = getTravelerPatronymic(document);

        return {
            id: document.id,
            passengerID: document.passenger_id,
            firstName: {value: firstName},
            patronymic: {value: patronymic},
            lastName: {value: lastName},
            type: {
                value: DOCUMENT_TYPE_BY_TRAVELER_DOCUMENT_TYPE[
                    document.type
                ] as TRAINS_DOCUMENT_TYPES,
            },
            number: {value: document.number},
            country: {value: document.citizenship},
            validDate: {value: document.expiration_date},
            clicked: false,
        };
    });
}
