import moment from 'moment';

import {IStoreTrainTravelerPassenger} from 'reducers/trains/order/types';
import {IPassengerWithDocumentsAndBonusCardsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';

import {ROBOT, HUMAN_DATE_RU} from 'utilities/dateUtils/formats';
import {getPatchedTravelerLoyaltyCards} from 'projects/trains/lib/order/traveler/patchServerResponse/getPatchedTravelerLoyaltyCards';
import {getPatchedTravelerPassengerDocuments} from 'projects/trains/lib/order/traveler/patchServerResponse/getPatchedTravelerPassengerDocuments';

/**
 * Функция преобразует ответ ручки для дальнейшего удобства работы с данными пассажира
 *
 * @param travelerPassengers – ответ ручки
 */
export function getPatchedTravelerPassengers(
    travelerPassengers: IPassengerWithDocumentsAndBonusCardsDTO[],
): IStoreTrainTravelerPassenger[] {
    return travelerPassengers.map(
        (passenger): IStoreTrainTravelerPassenger => ({
            itn: passenger.itn,
            train_notifications_enabled: passenger.train_notifications_enabled,
            title: passenger.title,
            id: passenger.id,
            created_at: passenger.created_at,
            updated_at: passenger.updated_at,
            phone_additional: passenger.phone_additional,
            phone: passenger.phone,
            email: passenger.email,
            documents: getPatchedTravelerPassengerDocuments(
                passenger.documents,
            ),
            loyaltyCards: getPatchedTravelerLoyaltyCards(passenger.bonus_cards),
            birthDate: {
                value: moment(passenger.birth_date, ROBOT).format(
                    HUMAN_DATE_RU,
                ),
            },
            gender: {
                value: passenger.gender,
            },
        }),
    );
}
