import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

import {IDocumentDTO} from 'server/api/TravelersApi/types/IDocumentDTO';

import {CHAR_DASH} from 'utilities/strings/charCodes';
import {DOCUMENT_TYPE_BY_TRAVELER_DOCUMENT_TYPE} from 'projects/trains/lib/order/passengers/documentTypes';
import {FOREIGN_DOCUMENT} from 'projects/account/lib/travellers/documents';
import {isPatronymicEmpty} from 'projects/trains/lib/order/fields/patronymic';

const DOCUMENTS_WITH_ENG_CHARS_SUPPORT = [
    TRAINS_DOCUMENT_TYPES.RUSSIAN_INTERNATIONAL_PASSPORT,
    FOREIGN_DOCUMENT,
];

/**
 * Функция возвращает отчество по документу пассажира путешественника для пропатченных для клиента данных
 * используется для функции getPatchedTravelerPassengerDocuments
 *
 * @param document - документ пассажира путешественника
 */
export default function getTravelerPatronymic(
    document: IDocumentDTO,
): string | undefined {
    const patronymic = document.middle_name || document.middle_name_en;

    const documentType = DOCUMENT_TYPE_BY_TRAVELER_DOCUMENT_TYPE[document.type];

    // Если отчество задано - возвращаем его.
    // Если это документ с поддержкой только кириллических символов, то если нету кириллического имени или фамилии,
    // то оставляем отчество пустым, в ином случае можем считать, что отчества нет и выставить дефис
    // Нужно для кейса, когда, например, человек купил билет на Авиа, в записную книжку добавились только латинские
    // имя и фамиллия, а пасспорт при этом российский. У нас в таком кейсе преобрести билет не получится, т.к. нам нужны
    // кириллические фио. Оставляем фио пустым, без дефиса в отчестве.
    return !isPatronymicEmpty(patronymic)
        ? patronymic
        : !DOCUMENTS_WITH_ENG_CHARS_SUPPORT.includes(documentType) &&
          (!document.first_name || !document.last_name)
        ? ''
        : CHAR_DASH;
}
