import get from 'lodash/get';
import isNumber from 'lodash/isNumber';

import {ITrainsCoach, ITrainsRequirements} from 'reducers/trains/order/types';

/**
 * Вернёт количество мест в вагоне
 *
 * @param coach - данные вагона
 */
export function getCoachPlacesCount(coach: ITrainsCoach): number {
    const {places, placeCounts} = coach;

    if (places && places.length) {
        return places.length;
    }

    if (placeCounts && isNumber(placeCounts.total)) {
        return placeCounts.total;
    }

    return 0;
}

/**
 * Функция проверяет наличие требований к местам, если нет схемы вагона,
 * которые соответствуют сидячим/несидячим вагонам
 *
 * @param requirements - объект требований к местам
 */
export const isNotEmptyCountField = (
    requirements: ITrainsRequirements,
): boolean =>
    (Number.isInteger(get(requirements, 'count.nearWindow')) &&
        Number.isInteger(get(requirements, 'count.nearPassage'))) ||
    (Number.isInteger(get(requirements, 'count.upper')) &&
        Number.isInteger(get(requirements, 'count.bottom')));
