import {ERestrictionType} from 'projects/trains/lib/order/fields/restrictions/types';

/**
 * Создаёт простой RestrictionChecker
 */
export const createRestriction =
    <S, P>(type: ERestrictionType, checker: (state: S) => P) =>
    (state: S): {type: ERestrictionType; payload: P}[] => {
        const payload = checker(state);

        return payload ? [{type, payload}] : [];
    };

/**
 * Функция возвращает первую ошибку же ошибку из всех проверок.
 */
export const prioritizeRestrictions =
    <S, P>(
        restrictions: ((state: S) => {type: ERestrictionType; payload: P}[])[],
    ) =>
    (state: S): {type: ERestrictionType; payload: P}[] => {
        const l = restrictions.length;

        for (let i = 0; i < l; i++) {
            const result = restrictions[i](state);

            if (result.length > 0) {
                return result;
            }
        }

        return [];
    };
