export enum ESearchErrorTypes {
    COMMON = 'common',
    OUT_DATE = 'outdate',
    POINT_NOT_FOUND = 'point_not_found',
    SAME_POINTS = 'same_points',
}

interface ICommonSearchErrorProps {
    message?: string;
    status?: number;
}

export class CommonSearchError extends Error {
    status?: number;

    constructor({message, status}: ICommonSearchErrorProps = {}) {
        super(message);
        this.status = status;
    }
}
export class OutdatedSearchError extends Error {}
export class PointNotFoundSearchError extends Error {}
export class SamePointsSearchError extends Error {}
