import {WHEN_SPECIAL_VALUE} from 'types/common/When';
import {
    ITrainsFilledSearchContext,
    TrainsSearchContextType,
} from 'reducers/trains/context/types';

/**
 * Является ли этот запрос поиском на "сегодня" (today)
 *
 * @param context -  поисковый контекст
 */
export function isTodaySearch(context: TrainsSearchContextType): boolean;
export function isTodaySearch(context: ITrainsFilledSearchContext): boolean;
export function isTodaySearch(
    context: TrainsSearchContextType | ITrainsFilledSearchContext,
): boolean {
    return context.originalWhen === WHEN_SPECIAL_VALUE.TODAY;
}

/**
 * Является ли этот запрос поиском на "завтра" (tomorrow)
 *
 * @param context -  поисковый контекст
 */
export function isTomorrowSearch(context: ITrainsFilledSearchContext): boolean;
export function isTomorrowSearch(context: TrainsSearchContextType): boolean;
export function isTomorrowSearch(
    context: TrainsSearchContextType | ITrainsFilledSearchContext,
): boolean {
    return context.originalWhen === WHEN_SPECIAL_VALUE.TOMORROW;
}
