import {
    MAIN_TRAIN_FEATURES,
    META_SUB_SEGMENT_FEATURES,
    ITrainFeature,
} from './types';

/**
 * Фильтрует специфичную для данного типа транспорта информацию.
 *
 * @param features - информация о транспорте
 * @param segment - опции
 */
export default function filterTrainFeatures(
    features: ITrainFeature[],
    segment: {isMetaSegment?: boolean},
): ITrainFeature[] {
    const availableFeatures =
        'isMetaSegment' in segment
            ? META_SUB_SEGMENT_FEATURES
            : MAIN_TRAIN_FEATURES;

    return features.filter(({type}) => availableFeatures.includes(type));
}
