import {ITrainFeature, TRAIN_FEATURES_TYPES} from './types';
import {
    TTrainsOrderSelectorSegment,
    TTrainsStoreOrderSegment,
} from 'projects/trains/lib/segments/types';

/**
 * Вернёт список компаний сегмента
 *
 * @param segment - данные сегмента
 */
export default function getCompanies(
    segment: TTrainsOrderSelectorSegment | TTrainsStoreOrderSegment,
): ITrainFeature[] {
    const companies =
        'companies' in segment
            ? segment.companies
            : 'company' in segment
            ? [segment.company]
            : [];
    const features: ITrainFeature[] = [];

    companies?.forEach(company => {
        if (company) {
            const companyTitle =
                company.shortTitle || company.title || company.ufsTitle;

            if (companyTitle) {
                features.push({
                    type: TRAIN_FEATURES_TYPES.COMPANY,
                    props: {},
                    content: companyTitle,
                });
            }
        }
    });

    return features;
}
