import {ITrainFeature, TRAIN_FEATURES_TYPES} from './types';
import {
    TTrainsOrderSelectorSegment,
    TTrainsStoreOrderSegment,
} from 'projects/trains/lib/segments/types';

import {clearMarkup} from 'projects/trains/lib/strings/stringUtils';

import * as i18nBlock from 'i18n/trains-segment';

/**
 * Вернёт данные о подтипе сегмента
 *
 * @param segment - данные сегмента
 */
export default function getSubtype(
    segment: TTrainsOrderSelectorSegment | TTrainsStoreOrderSegment,
): ITrainFeature | null {
    const {transport} = segment;
    const {subtype} = transport;
    const isExpress =
        'thread' in segment && segment.thread && segment.thread.isExpress;

    const subtypeTitle = subtype && subtype.title;
    const isSubtypeOrExpress =
        (subtypeTitle && subtype && subtype.id !== transport.id) || isExpress;

    if (!isSubtypeOrExpress) {
        return null;
    }

    return {
        type: TRAIN_FEATURES_TYPES.SUBTYPE,
        props: {
            style:
                subtype && subtype.titleColor
                    ? {color: subtype.titleColor}
                    : {},
        },
        content: subtypeTitle ? clearMarkup(subtypeTitle) : i18nBlock.express(),
    };
}
