import {TRAIN_FEATURES_TYPES, ITrainFeature} from './types';
import {
    TTrainsOrderSelectorSegment,
    TTrainsStoreOrderSegment,
} from 'projects/trains/lib/segments/types';

import getSubtype from 'projects/trains/lib/segments/features/getSubtype';
import getCompanies from 'projects/trains/lib/segments/features/getCompanies';
import hasElectronicRegistration from 'projects/trains/lib/segments/features/hasElectronicRegistration';

import * as i18nBlock from 'i18n/trains-segment';

/* TODO: вернуть когда будет страница сапсанов
const DELUXE_TRAIN_HREF = {
    [DELUXE_TRAIN_IDS.SAPSAN]: '/sapsan'
};
*/

/**
 * Метод получения информации о транспорте
 *
 * @param segment - данные сегмента
 */
export function getTrainFeatures(
    segment: TTrainsOrderSelectorSegment | TTrainsStoreOrderSegment,
): ITrainFeature[] {
    const {transport} = segment;

    const features = [];
    const {model} = transport;
    const deluxeTrain =
        'thread' in segment && segment.thread && segment.thread.deluxeTrain;

    const deluxeTrainName = deluxeTrain ? deluxeTrain.shortTitle : '';
    const subtype = getSubtype(segment);

    if (hasElectronicRegistration(segment)) {
        features.push({
            type: TRAIN_FEATURES_TYPES.ETICKET,
        });
    }

    if ('hasDynamicPricing' in segment && segment.hasDynamicPricing) {
        features.push({
            type: TRAIN_FEATURES_TYPES.DYNAMIC_PRICING,
        });
    }

    if (subtype) {
        features.push(subtype);
    } else {
        switch (true) {
            case 'isThroughTrain' in segment && segment.isThroughTrain:
                features.push({
                    type: TRAIN_FEATURES_TYPES.TROUGH_TRAIN,
                    content: i18nBlock.throughDashTrain(),
                });

                break;

            case Boolean(deluxeTrainName): {
                const feature: ITrainFeature = {
                    type: TRAIN_FEATURES_TYPES.DELUXE_TRAIN,
                    content: deluxeTrainName,
                };

                /* TODO: вернуть когда будет страница сапсанов
                const deluxeTrainHref =
                    deluxeTrain && DELUXE_TRAIN_HREF[deluxeTrain.id];

                if (deluxeTrainHref) {
                    feature.props = {href: deluxeTrainHref};
                }
                */

                features.push(feature);

                break;
            }
        }
    }

    features.push(...getCompanies(segment));

    if (model && model.title) {
        features.push({
            type: TRAIN_FEATURES_TYPES.MODEL,
            content: model.title,
        });
    }

    return features;
}
