import {
    TTrainsOrderSelectorSegment,
    TTrainsStoreOrderSegment,
} from 'projects/trains/lib/segments/types';

/**
 * Вернёт признак наличия электронной регистрации для сегмента
 *
 * @param segment - данные сегмента
 */

export default function hasElectronicRegistration(
    segment: TTrainsOrderSelectorSegment | TTrainsStoreOrderSegment,
): boolean {
    return Boolean(
        'tariffs' in segment &&
            segment.tariffs &&
            'electronicTicket' in segment.tariffs &&
            segment.tariffs.electronicTicket,
    );
}
