import {ETimeOfDay} from 'utilities/dateUtils/types';
import {ITrainsTariffApiSegment} from 'server/api/TrainsApi/types/ITrainsGetTariffsApi/models';

import {getTimeOfDay} from 'utilities/dateUtils';
import {getLocalDepartureTime} from 'projects/trains/lib/segments/cachedSegmentTime';

/*
 * Вернет название части суток (утро, день и тд) для времени отправления сегмента.
 * Сегменты, отправляющиеся ночью на следующий день относительно даты поиска мы считаем вечерними.
 */
export default function getSegmentDepartureTimeOfDay(
    segment: ITrainsTariffApiSegment,
): ETimeOfDay {
    const hour = getLocalDepartureTime(segment).hour();

    return getTimeOfDay(hour);
}
