import {ITrainsTariffs} from 'server/api/TrainsApi/types/ITrainsGetTariffsApi/models';

/**
 * Функция возвращает признак - есть ли причнина отсутсвия цен для тарифов.
 */
export default function hasTrainsSegmentPriceDescription(
    tariffs: ITrainsTariffs | undefined,
): boolean {
    if (!tariffs) {
        return false;
    }

    const brokenClasses =
        'brokenClasses' in tariffs ? tariffs.brokenClasses : undefined;

    if (!brokenClasses) {
        return false;
    }

    const classesCoachTypes = Object.keys(tariffs.classes || {});

    /*
     * Если есть хотя бы одна цена, то не нужно отображать причину отсутствия цен.
     */
    if (classesCoachTypes.length) {
        return false;
    }

    return Boolean(Object.values(brokenClasses).length);
}
