import {Overwrite} from 'utility-types';

import {ABROAD_COUNTRIES} from 'projects/trains/constants/countries';

import {IDeluxeTrain, IThread} from 'projects/trains/lib/segments/types';

/**
 * Проверка, что нитка начинается или заканчивается в странах из проекта заграничных направлений.
 *
 * @param thread - объект нитки
 */
export default function isAbroadThread(
    thread: Overwrite<IThread, {deluxeTrain?: IDeluxeTrain | null}>,
): boolean {
    return Boolean(
        ABROAD_COUNTRIES.includes(thread?.firstCountryCode) ||
            ABROAD_COUNTRIES.includes(thread?.lastCountryCode),
    );
}
